"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Multitenancy = void 0;
var _coreDocLinksServerInternal = require("@kbn/core-doc-links-server-internal");
var _routes = require("./routes");
var _multitenancy_lifecycle = require("./multitenancy_lifecycle");
/* eslint-disable @kbn/eslint/require-license-header */
/**
 *    Copyright 2020 floragunn GmbH

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

class Multitenancy {
  constructor(coreContext) {
    this.coreContext = coreContext;
    this.logger = coreContext.logger.get('searchguard-multitenancy');
    this.enabled = true;
  }
  async setup({
    kibanaRouter,
    authManager,
    kerberos,
    kibanaCore,
    sessionStorageFactory,
    pluginDependencies,
    configService,
    searchGuardBackend,
    spacesService,
    tenantService,
    savedObjects,
    elasticsearch
  }) {
    this.logger.debug('Setup app');
    const requestHeadersWhitelist = configService.get('elasticsearch.requestHeadersWhitelist');
    if (!requestHeadersWhitelist.includes('sgtenant')) {
      throw new Error('No tenant header found in whitelist. Please add sgtenant to elasticsearch.requestHeadersWhitelist in kibana.yml');
    }
    try {
      const multitenancyLifecycle = new _multitenancy_lifecycle.MultitenancyLifecycle({
        authManager,
        kerberos,
        searchGuardBackend,
        configService,
        sessionStorageFactory,
        logger: this.logger,
        clusterClient: elasticsearch.client,
        pluginDependencies,
        spacesService,
        kibanaCore
      });
      kibanaCore.http.registerOnPreAuth(multitenancyLifecycle.onPreAuth);
    } catch (error) {
      this.logger.error(`setup: ${error.toString()} ${error.stack}`);
    }
    this.syncMultiTenancyEnabled(searchGuardBackend, configService);
  }
  syncMultiTenancyEnabled(searchGuardBackend, configService) {
    // Now when the routes have been defined, we check that MT is really enabled in the BE
    searchGuardBackend.getKibanaInfoWithInternalUser().then(kibanaInfo => {
      configService.set('searchguard.multitenancy.enabled', kibanaInfo.kibana_mt_enabled);
      if (kibanaInfo.kibana_mt_enabled) {
        const requestHeadersWhitelist = configService.get('elasticsearch.requestHeadersWhitelist');
        if (!requestHeadersWhitelist.includes('sgtenant')) {
          throw new Error('No tenant header found in whitelist. Please add sgtenant to elasticsearch.requestHeadersWhitelist in kibana.yml');
        }
      }
    });
  }
  async start({
    core,
    searchGuardBackend,
    configService,
    kibanaRouter,
    elasticsearch,
    sessionStorageFactory
  }) {
    this.logger.debug('Start app');
    (0, _routes.defineMultitenancyRoutes)({
      router: kibanaRouter,
      searchGuardBackend,
      config: configService,
      sessionStorageFactory,
      // TODO or take this from the route context?
      logger: this.logger,
      clusterClient: elasticsearch.client
    });
    this.syncMultiTenancyEnabled(searchGuardBackend, configService);
  }
}
exports.Multitenancy = Multitenancy;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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